<?php

namespace Elementor;

use Qoxag\Core\Elementor\Controls\Qoxag_Post_Query;

if ( ! defined( 'ABSPATH' ) ) exit;


class Qoxag_Author extends Widget_Base {


  public $base;

    public function get_name() {
        return 'author';
    }

    public function get_title() {

        return esc_html__( 'Author', 'qoxag' );

    }

    public function get_icon() { 
        return 'eicon-user-circle-o';
    }

    public function get_categories() {
        return [ 'qoxag-elements' ];
    }

    protected function register_controls() {

      $this->start_controls_section(
         'settings_tab',
         [
               'label' => esc_html__('Settings', 'qoxag'),
             'tab' => Controls_Manager::TAB_CONTENT,
         ]
      );

        $this->add_group_control(
            Qoxag_Post_Query::get_type(),
            [
                'name' => 'query',
                'include' => [ 'posts_per_page', 'orderby', 'order' ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'styles_tab',
            [
                'label' => esc_html__('Styles', 'qoxag'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'qoxag' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#161B2A',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-authors .author-name' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            array(
                'name'     => 'title_typography',
                'label'    => esc_html__('Title Typography ', 'qoxag'),
                'selector' => '{{WRAPPER}} .qoxag-authors .author-name',
                'fields_options'    => [
                    'typography'    => [
                        'default'   => 'custom',
                    ],
                    'font_weight'   => [
                        'default'   => '700',
                    ],
                    'font_size'     => [
                        'default'   => [
                            'size'  => '19',
                            'unit'  => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                    'text_transform'    => [
                        'default'   => 'normal',
                    ],
                    'line_height'   => [
                        'default'   => [
                            'size'  => '24',
                            'unit'  => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                ],
            )
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__( 'Title Margin', 'qoxag' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'default'   => [
                    'top' => '0',
                    'right' => '0',
                    'bottom' => '10',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-authors .author-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'count_color',
            [
                'label' => esc_html__( 'Post Count Color', 'qoxag' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#666F82',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-authors .post-count' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            array(
                'name'     => 'count_typography',
                'label'    => esc_html__('Post Count Typography ', 'qoxag'),
                'selector' => '{{WRAPPER}} .qoxag-authors .post-count',
                'fields_options'    => [
                    'typography'    => [
                        'default'   => 'custom',
                    ],
                    'font_weight'   => [
                        'default'   => '400',
                    ],
                    'font_size'     => [
                        'default'   => [
                            'size'  => '13',
                            'unit'  => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                    'text_transform'    => [
                        'default'   => 'normal',
                    ],
                    'line_height'   => [
                        'default'   => [
                            'size'  => '15',
                            'unit'  => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                ],
            )
        );

        $this->add_responsive_control(
            'count_margin',
            [
                'label' => esc_html__( 'Post Count Margin', 'qoxag' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'default'   => [
                    'top' => '0',
                    'right' => '0',
                    'bottom' => '15',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-authors .post-count' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'link_color',
            [
                'label' => esc_html__( 'Link Color', 'qoxag' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#4E65FF',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-authors .posts-link' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'link_hover_color',
            [
                'label' => esc_html__( 'Link Hover Color', 'qoxag' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#4E65FF',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-authors .posts-link' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'image_border_radius',
            [
                'label'     => esc_html__('Border Radius', 'qoxag'),
                'type'      => Controls_Manager::DIMENSIONS,
                'default'   => [
                    'top' => '0',
                    'right' => '0',
                    'bottom' => '0',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-authors .author-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'wrapper_margin',
            [
                'label' => esc_html__( 'Wrapper Margin', 'qoxag' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'default'   => [
                    'top' => '10',
                    'bottom' => '10',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-authors .single-author' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render( ) {
        $settings = $this->get_settings_for_display();

        $tpl = get_widget_template($this->get_name());
        include $tpl;
    }



    protected function content_template() { }
}